#pragma once
//ESTRUCTURAS EXPUESTAS AL EXTERIOR
#include "ClasesFotogrametria.h"

typedef struct _PuntoXYZt{
 double X,Y,Z,t;
} PuntoXYZt;

typedef struct _PuntoGPSINS{
 PuntoXYZMn_BODY(double)
 double t;
 PuntoXYZ_double offset;
 umint bg;
 umint bi;
 uint grupo;
 umint tipoGPS;
 umint tipoINS;
 uint peso;
} PuntoGPSINS;
#define default_values_GPS(g) \
	(g).bg=(g).bi=1;\
	(g).peso=0;\
	(g).offset.Z=(g).offset.Y=(g).offset.X=0

typedef struct _GrupoGPSINS{
 Index;	//Los grupos en principo son anónimos, pero pueden apuntar a un nombre
 umint tipoGPS;
 umint tipoINS;
 umint param;	//0, tiempo; 1, distancia.
 double tiempo0;
 PuntoXYZ_double offset;
 PuntoXYZ_double despl;
 PuntoXYZ_double deriva;
 double desplins[3][3];
 Giro3D_double derivains;
 uint n;	//número de observaciones que incluye este grupo
 umint bg;
 umint bi;
 uint peso;	//apuntará al mismo array de pesos que los puntos_gps.
} GrupoGPSINS;

#define GrupoGPSINS_TDGPS_Offset	 255	//valor de tipoGPS/INS para offset

#define default_values_GrupoGPS(g) \
	(g).bg=(g).bi=1;\
	(g).peso=0;\
	(g).param=255;	/*Emplear el tiempo si hay datos de tiempo; si no, la distancia*/ \
	(g).offset.Z=(g).offset.Y=(g).offset.X=0

#define GrupoGPS_copy_desviaciones(g1,g2) memcpy_uint(&(g1)->despl,&(g2)->despl,18*uintsizeof(double));
#define GrupoGPS_zeroset_desviaciones(g) zeroset_double(&(g).despl.X,18);

defineVector(PuntoGPSINS)
defineVector(GrupoGPSINS)
#undef Index
